#ifndef OURDREAM_2D_H
#define OURDREAM_2D_H

#include "IInterface.h"
#include "RenderSystem.h"
#include "InputSystem_Win32.h"
#include "MediaSystem.h"
#include "GUISystem.h"
#include "SpriteSystem.h"
#include "ParticleSystem.h"
#include "ComDef.h"

#define OURDREAM2D_VERSION 0x2093204

class IOurDream2D
{
public:
	virtual bool CALL Initialize(SOD2DSystemSetup setup)=0;
	
	// Ӧüֵ
	virtual int CALL HowManyOdeUsed(void)=0;
	
	virtual int CALL SystemRun(void)=0;
	virtual void CALL SystemStop(void)=0;
	
	virtual void CALL SystemPause(void)=0;
	virtual void CALL SystemRestore(void)=0;
	
	virtual void CALL Release(void)=0;

	virtual void CALL ShowLogo(void)=0;
	virtual void CALL DisableLogo(void)=0;
	//////////////////////////////////////////////////////////////////////////
	virtual LPSTR CALL MakePath(LPSTR FileName)=0;
	virtual float CALL GetTimeDelta(void)=0;
	virtual float CALL GetTime(void)=0;
	virtual int CALL GetFPS(void)=0;
	//////////////////////////////////////////////////////////////////////////
	virtual HWND CALL GetWindowHandl(void)=0;

	virtual void CALL SetFrameFunction(OD2DCallback Func)=0;
	virtual OD2DCallback CALL GetFrameFunction(void)=0;
	virtual void CALL SetRenderFunction(OD2DCallback Func)=0;
	virtual OD2DCallback CALL GetRenderFunction(void)=0;
	virtual void CALL SetSystemCleanFunction(OD2DCallback Func)=0;
	virtual OD2DCallback CALL GetSystemCleanFunction(void)=0;
	virtual void CALL SetFocusGainFunction(OD2DCallback Func)=0;
	virtual OD2DCallback CALL GetFocusGainFunction(void)=0;
	virtual void CALL SetFocusLostFunction(OD2DCallback Func)=0;
	virtual OD2DCallback CALL GetFocusLostFunction(void)=0;

	virtual void CALL SetMessageProc(MyMessageProc Func)=0;
	virtual MyMessageProc CALL GetMessageProc(void)=0;
	//////////////////////////////////////////////////////////////////////////
	virtual DWORD CALL TransformColor(int a, int r, int g, int b)=0;
	virtual DWORD CALL GetAFromColor(DWORD color)=0;
	virtual DWORD CALL GetRFromColor(DWORD color)=0;
	virtual DWORD CALL GetGFromColor(DWORD color)=0;
	virtual DWORD CALL GetBFromColor(DWORD color)=0;
	virtual DWORD CALL SetAToColor(DWORD color, int a)=0;
	virtual DWORD CALL SetRToColor(DWORD color, int r)=0;
	virtual DWORD CALL SetGToColor(DWORD color, int g)=0;
	virtual DWORD CALL SetBToColor(DWORD color, int b)=0;
	//////////////////////////////////////////////////////////////////////////
	virtual IRenderSystem * CALL GetRender(void)=0;
	virtual SOD2DSystemSetup CALL GetSystemSetup(void)=0;
	//////////////////////////////////////////////////////////////////////////
	virtual IInputSystem_Win32 * CALL GetWin32Inputer(void)=0;
	//////////////////////////////////////////////////////////////////////////
	virtual ISoundSystem * CALL GetSoundSystem(void)=0;
	//////////////////////////////////////////////////////////////////////////
	virtual IMediaSystem * CALL GetMediaSystem(void)=0;
	//////////////////////////////////////////////////////////////////////////
	virtual CGUISystem * CALL GetGUISystem(void)=0;
	//////////////////////////////////////////////////////////////////////////
	virtual ISpriteSystem * CALL GetSprite(void)=0;
	//////////////////////////////////////////////////////////////////////////
	virtual IParticleSystem * CALL GetParticleSystem(void)=0;
};

extern "C" { EXPORT IOurDream2D * CALL Create3D(int ver); }

#endif